import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/helper/string_format_helper.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/style.dart';
import 'package:viserpay_agent/data/controller/cash_in/cash_in_controller.dart';
import 'package:viserpay_agent/view/components/bottom-sheet/bottom_sheet_close_button.dart';
import 'package:viserpay_agent/view/components/card/bottom_sheet_card.dart';

class CashInOtpBottomSheet extends StatelessWidget {
  const CashInOtpBottomSheet({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<CashInController>(
      builder: (controller) => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Align(
            alignment: Alignment.topCenter,
            child: Container(
              height: 5,
              width: 50,
              padding: const EdgeInsets.all(1),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(8),
                color: MyColor.colorGrey.withOpacity(0.1),
              ),
            ),
          ),
          const Row(
            mainAxisAlignment: MainAxisAlignment.end,
            children: [BottomSheetCloseButton()],
          ),
          const SizedBox(height: Dimensions.space15),
          ListView.builder(
              itemCount: controller.otpTypeList.length,
              shrinkWrap: true,
              physics: const NeverScrollableScrollPhysics(),
              itemBuilder: (context, index) {
                return GestureDetector(
                  onTap: () {
                    String selectedValue = controller.otpTypeList[index];
                    controller.setOtpMethod(selectedValue);
                    Navigator.pop(context);

                    FocusScopeNode currentFocus = FocusScope.of(context);
                    if (!currentFocus.hasPrimaryFocus) {
                      currentFocus.unfocus();
                    }
                  },
                  child: BottomSheetCard(
                    child: Text(
                      controller.otpTypeList[index].toString().toTitleCase(),
                      style: regularDefault,
                    ),
                  ),
                );
              })
        ],
      ),
    );
  }
}
